/*******************************************************************************
 *
 *                  M E N U   W I D G E T S
 *
 *              Copyright A Levido 2013 - All Rights Reserved
 *
 ******************************************************************************/
#ifndef WIDGETS_H
#define WIDGETS_H
#include "genericTypeDefs.h"
#include "graphics.h"

/* Colours ********************************************************************/
#define SCREEN_BG       WHITE
#define TITLE_BG_ERR    RED
#define TITLE_TXT_ERR   WHITE
#define LINE_ERR        RED
#define TITLE_TXT       GREEN
#define LINE            GREEN
#define TXT1_ERR        RED
#define TXT1            BLACK
#define TIME            DK_BLUE
#define DATE            DK_BLUE
#define BATT            DK_BLUE
#define GRAYED          LTLT_GREY
#define GRAYED_TXT      WHITE
#define NORMAL_TXT      WHITE

/* See also menu.h for button and clicker colours */
/* Buttons */

typedef struct {
    UINT16 colour;
    char* text;
    const UINT8* icon;
    BOOL inactive;
    UINT16 state;
    UINT16 maxstate;
    void (*fun)(UINT16 code);
    BOOL redraw;
}BUTTON;

/* Clickers */
typedef struct {
    UINT16 colour;
    char* text;
    const UINT8* iconUp;
    const UINT8* iconDn;
    BOOL inactive;
    void (*inc)(UINT16 code);
    void (*dec)(UINT16 code);
    BOOL redraw;
    BOOL update;
    BOOL drag;
}CLICKER;

typedef struct {
    int x1, y1, x2, y2;
    int rate;
    void (*inc)(UINT16 code);
    void (*dec)(UINT16 code);
    BOOL pressed;
    int press_x, press_y;
}SLIDER;

/* Screens */
typedef struct {
    char* titleText;
    char* line1Text;
    char* line2Text;
  
    CLICKER* clicker[3];
    BUTTON* button[15];
    SLIDER* slider[1];

    UINT8* time;
    UINT8* batt;
    UINT8* date;
    
    BOOL error;
    BOOL redraw;

    CLICKER* cur_clicker;
    int cur_clicker_x, cur_clicker_y;
    BOOL cur_clicker_drag;
}SCREEN;

void drawWidgets(SCREEN* scr);
void processTouch(SCREEN* scr, UINT16 code, INT16 x, INT16 y);
void processRelease(SCREEN* scr);

#define REDRAW_TITLE        0x00000001
#define REDRAW_LINE1        0x00000002
#define REDRAW_LINE2        0x00000004
#define REDRAW_TIME         0x00000008
#define REDRAW_ALL          0x80000000





#endif